/*------------------------------------------------------------------------------*
 * File Name: PeakParamInitHelperBase.h											*
 * Creation: 																	*
 * Purpose:																		*
 * Copyright (c) Originlab Corp. 2008											*
 * All Rights Reserved															*
 *																				*
 *	Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef		__PA_PARAMS_INIT_HELPER_BASE__
#define		__PA_PARAMS_INIT_HELPER_BASE__

#include <NLParams.h>

struct	PEAKINFOARGUMENTSLISTBASE;
struct	PEAKINFOARGUMENTSLISTPARAMS;
struct	PEAKINFOARGUMENTSLISTBASELINE;

struct	PEAKINFOARGUMENTSLISTFUNCTIONS			/// peak info arguments list functions
{
	vector<string>	vsFunctions;
};

typedef struct tagFitFunctionInfo
{
	string		strFunction;
	string		strFuncFile;
	Tree		trFF;
}FitFunctionInfo;

#define		ASSERT_AND_RETURN_FALSE			\
			ASSERT(false);					\
			return false;
			
class PeakParamInitHelperBase
{
public:
	
	PeakParamInitHelperBase(NLFitSession *pFitSession)
	{
		ASSERT(pFitSession);	
		m_pFitSession = pFitSession;
	}
	~PeakParamInitHelperBase()
	{		
	}

	virtual	bool		InitParamsMngr(PEAKINFOARGUMENTSLISTPARAMS*		pstPEAKINFOARGUMENTSLISTPARAMS = NULL,
							PEAKINFOARGUMENTSLISTFUNCTIONS*				pstPEAKINFOARGUMENTSLISTFUNCTIONS = NULL,
							PEAKINFOARGUMENTSLISTBASE*					pstPEAKINFOARGUMENTSLISTBASE = NULL,
							PEAKINFOARGUMENTSLISTBASELINE*				pstPEAKINFOARGUMENTSLISTBASELINE = NULL,
							bool*										pbHasBaselinePeak = NULL,
							bool										bLoadValuesFromFDFOnly = false,
							bool										bBaselineParamFixed = false)
	{
		ASSERT_AND_RETURN_FALSE
	}

	virtual	bool		ReinitParamsMngrOnFuncChange(const vector<int>&	vnPeakIndecies,
									PEAKINFOARGUMENTSLISTFUNCTIONS*		pstPEAKINFOARGUMENTSLISTFUNCTIONS = NULL,
									bool								bLoadValuesFromFDFOnly= false)
	{
		ASSERT_AND_RETURN_FALSE
	}

	virtual	bool		ReinitParamsMngrOnPeakChange(const vector<int>&	vnPeakIndecies,
									PEAKINFOARGUMENTSLISTPARAMS&		stPEAKINFOARGUMENTSLISTPARAMS,
									LPCSTR								lpcszDefaultFunction,
									bool								bLoadValuesFromFDFOnly = false,
									bool								bRemovePeak = false
									)
	{
		ASSERT_AND_RETURN_FALSE
	}
	
	void		UpdatePeaksParams(const PEAKINFOARGUMENTSLISTPARAMS& stPEAKINFOARGUMENTSLISTPARAMS)
	{
		setPeakInfoParams(stPEAKINFOARGUMENTSLISTPARAMS);
	}

	void		SetAutoRunInitParams(bool bOn = true)	{ m_bIsAutoRunInitParams = bOn; }
	bool		IsAutoRunInitParams() 					{ return m_bIsAutoRunInitParams; }
	
	virtual		LPCSTR				GetPeakFuncCategory()		{ ASSERT(false); return NULL; }
	virtual		LPCSTR				GetBaselineFuncCategory()	{ return NULL; }
	
protected:
	
	NLFitSession*				GetFitSession()								{ return m_pFitSession; }	
	NLParametersManager*		GetNLParamsMngr()							{ return GetFitSession()->GetNLParamsMngr(); }
	FitFunctionInfo&			GetCacheFitFunctionInfo()					{ return m_cacheFitFunctionInfo; }
	
	void						CheckUpdateCacheFitFunctionInfo(LPCSTR lpcszFunction)
	{
		FitFunctionInfo&	fitFuncInfo = GetCacheFitFunctionInfo();
		if ( fitFuncInfo.trFF.IsEmpty() || fitFuncInfo.strFunction.CompareNoCase(lpcszFunction) != 0 )
		{
			fitFuncInfo.strFunction = lpcszFunction;
			string	strCategory = GetPeakFuncCategory();
			nlf_get_fdf_filename(lpcszFunction, &strCategory, NULL, &fitFuncInfo.strFuncFile);
			nlsf_load_FDF_to_tree(fitFuncInfo.strFuncFile, &fitFuncInfo.trFF, FDFT_CONVERT_BOOL_TO_01, true);
		}
	}
	
private:
	
	virtual	void				setPeakInfoParams(const PEAKINFOARGUMENTSLISTPARAMS& stPEAKINFOARGUMENTSLISTPARAMS)		{ ASSERT(false); }
	
private:
	
	NLFitSession				*m_pFitSession;
	bool						m_bIsAutoRunInitParams;
	
	FitFunctionInfo				m_cacheFitFunctionInfo;
};
	
#endif		/// __PA_PARAMS_INIT_HELPER_BASE__